package com.example.sefinsa_app.utilities;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import android.util.Log;


public class DeviceUtils {

    private static final String TAG = "DeviceUtils"; // Tag para los logs

    // Método para detectar si el dispositivo usa MIUI
    public static boolean isMIUI() {
        try {
            String miuiVersion = getSystemProperty("ro.miui.ui.version.name");
            if (miuiVersion != null && !miuiVersion.isEmpty()) {
                return true;
            } else {
                return false;
            }
        } catch (Exception e) {
            return false;
        }
    }

    // Método para obtener las propiedades del sistema
    private static String getSystemProperty(String propName) {
        try {
            Process process = Runtime.getRuntime().exec("getprop " + propName);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = reader.readLine();
            reader.close();
            return line;
        } catch (Exception e) {
            Log.e(TAG, "Error obteniendo propiedad del sistema: " + e.getMessage());
            return null;
        }
    }

}
